<?php
/**
 * Keyboard dan button untuk bot
 */

/**
 * Main keyboard untuk halaman utama
 */
function getMainKeyboard()
{
    return [
        'inline_keyboard' => [
            [
                ['text' => '📂 Public Files', 'callback_data' => 'files'],
                ['text' => '📁 Category', 'callback_data' => 'categories']
            ],
            [
                ['text' => '🔍 Search Files', 'callback_data' => 'search'],
                ['text' => '🛠️ Tools', 'callback_data' => 'tools_menu']
            ],
            [
                ['text' => '❓ Help', 'callback_data' => 'help']
            ]
        ]
    ];
}

/**
 * Keyboard untuk kategori
 */
function getCategoriesKeyboard($isPremium = false)
{
    return [
        'inline_keyboard' => [
            [
                ['text' => 'All Categories', 'callback_data' => 'categories:all:'.($isPremium ? '1' : '0')]
            ],
            [
                ['text' => '◀️ Back', 'callback_data' => $isPremium ? 'premium' : 'files']
            ]
        ]
    ];
}

/**
 * Keyboard untuk pencarian
 */
function getSearchKeyboard($isPremium = false)
{
    return [
        'inline_keyboard' => [
            [
                ['text' => '🔍 Search More', 'callback_data' => 'search'],
                ['text' => '◀️ Back', 'callback_data' => $isPremium ? 'premium' : 'files']
            ]
        ]
    ];
}

/**
 * Keyboard untuk admin
 */
function getAdminKeyboard()
{
    return [
        'inline_keyboard' => [
            [
                ['text' => '📤 Upload File', 'callback_data' => 'admin_upload'],
                ['text' => '🔑 Generate Key', 'callback_data' => 'admin_keys']
            ],
            [
                ['text' => '👥 Kelola Member', 'callback_data' => 'admin_members'],
                ['text' => '📊 Statistik', 'callback_data' => 'admin_stats']
            ],
            [
                ['text' => '🏠 Menu Utama', 'callback_data' => 'help']
            ]
        ]
    ];
}

/**
 * Keyboard untuk konfirmasi
 */
function getConfirmKeyboard($action, $id)
{
    return [
        'inline_keyboard' => [
            [
                ['text' => '✅ Ya', 'callback_data' => $action . '_confirm:' . $id],
                ['text' => '❌ Batal', 'callback_data' => 'cancel']
            ]
        ]
    ];
}

/**
 * Keyboard untuk back button
 */
function getBackKeyboard($callback = 'help')
{
    return [
        'inline_keyboard' => [
            [
                ['text' => '◀️ Back', 'callback_data' => $callback]
            ]
        ]
    ];
}

/**
 * Keyboard untuk navigasi file
 */
function getFileNavigationKeyboard($page = 1, $isPremium = false)
{
    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '◀️ Prev', 'callback_data' => 'page:' . ($page - 1) . ':' . $isPremium],
                ['text' => 'Page ' . $page, 'callback_data' => 'current_page'],
                ['text' => '▶️ Next', 'callback_data' => 'page:' . ($page + 1) . ':' . $isPremium]
            ],
            [
                ['text' => '🏠 Main Menu', 'callback_data' => 'help']
            ]
        ]
    ];
    
    return $keyboard;
}

function getToolsKeyboard() {
    return [
        'inline_keyboard' => [
            [
                ['text' => '🖼️ Image to Base64', 'callback_data' => 'tool_image_to_base64']
            ],
            [
                ['text' => '◀️ Back', 'callback_data' => 'help']
            ]
        ]
    ];
}