<?php
/**
 * Perintah-perintah bot
 */

/**
 * Proses perintah dari pengguna
 */
function processCommand($text, $chatId, $userId, $db) {
    $command = strtolower(explode(' ', $text)[0]);
    
    // Process download command
    if (strpos($command, '/download_') === 0) {
        $fileId = substr($command, 10);
        processFileDownload($chatId, $userId, $fileId, $db);
        return;
    }
    
    switch ($command) {
        case '/start':
            cmdStart($chatId, $userId, $db);
            break;
            
        case '/help':
            showHelp($chatId);
            break;
            
        case '/files':
            showFiles($chatId, $userId, $db, false);
            break;
            /*
        case '/premium':
            if (hasAccessToMemberArea($userId, $db)) {
                showFiles($chatId, $userId, $db, true);
            } else {
                showMemberAreaInfo($chatId);
            }
            break;
            */
        case '/categories':
            showCategories($chatId, $userId, $db, false);
            break;
            
        case '/search':
            $searchQuery = trim(substr($text, strlen('/search')));
            if (empty($searchQuery)) {
                sendMessage($chatId, "🔍 Type /search followed by keyword you want to search for\nExample: /search lua script", getSearchKeyboard());
                return;
            }
            handleSearch($chatId, $userId, $searchQuery, $db);
            break;
            
        case (preg_match('/^\/category_(\d+)$/', $command, $matches) ? $command : false):
            $categoryId = $matches[1];
            showFiles($chatId, $userId, $db, false, $categoryId);
            break;
           /* 
        case '/activate':
    $key = trim(substr($text, strlen('/activate')));
    if (empty($key)) {
        $message = "🌟 <b>PREMIUM MEMBERSHIP ACTIVATION</b> 🌟\n";
        $message .= str_repeat("═", 27) . "\n";
        $message .= "🔐 <i>Unlock exclusive content with your activation key</i>\n\n";
        
        $message .= "📌 <b>HOW TO ACTIVATE:</b>\n";
        $message .= "1. Type <code>/activate YOUR_KEY</code>\n";
        $message .= "2. Press send button\n\n";
        
        $message .= "🖊️ <b>EXAMPLE:</b>\n";
        $message .= "<code>/activate ABCD-EFGH-IJKL-MNOP</code>\n\n";
        
        $message .= "⚠️ <i>Key Requirements:</i>\n";
        $message .= "• 16 alphanumeric characters\n";
        $message .= "• No spaces or special characters\n";
        $message .= "• Case insensitive\n\n";
        
        $message .= "🔑 <i>Don't have a key? Contact</i> @rinda_escobar";

        $keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => '💳 GET PREMIUM KEY', 'url' => 'https://t.me/rinda_escobar'],
                    ['text' => '❓ HELP', 'callback_data' => 'activation_guide']
                ]
            ]
        ];
        
        sendMessage($chatId, $message, $keyboard);
        return;
    }
    
    // Validate key format first
    if (!preg_match('/^[A-Za-z0-9]{16}$/', $key)) {
        $formattedKey = chunk_split($key, 4, '-');
        $formattedKey = rtrim($formattedKey, '-');
        
        $message = "⚠️ <b>INVALID KEY FORMAT</b> ⚠️\n";
        $message .= str_repeat("═", 27) . "\n";
        $message .= "The key you entered doesn't match required format:\n\n";
        $message .= "❌ <b>Your Input:</b> <code>$formattedKey</code>\n";
        $message .= "✅ <b>Expected Format:</b> <code>ABCD-EFGH-IJKL-MNOP</code>\n\n";
        $message .= "🔧 <b>Please try again:</b>\n";
        $message .= "<code>/activate " . substr($key, 0, 16) . "</code>\n\n";
        $message .= "💡 <i>Note: Hyphens are optional</i>";
        
        sendMessage($chatId, $message);
        return;
    }
    
    // Show processing message
    $processingMsg = "⏳ <b>VERIFYING YOUR KEY...</b>\n";
    $processingMsg .= str_repeat("═", 27) . "\n";
    $processingMsg .= "🔍 Checking premium access credentials...\n\n";
    $processingMsg .= "🆔 <b>Key:</b> <code>" . chunk_split($key, 4, '-') . "</code>\n";
    $processingMsg .= "🕒 Please wait...";
    
    sendChatAction($chatId, 'typing');
    $msgId = sendMessage($chatId, $processingMsg)['result']['message_id'];
    
    // Process activation
    $result = processKeyActivation($key, $chatId, $userId, $db);
    
    // Delete processing message
    deleteMessage($chatId, $msgId);
    break;    
         */   
        default:
            $message = "❓ <b>Unrecognized Command</b>\n";
            $message .= "══════════════════════════\n";
            $message .= "The command you entered is not available.\n\n";
            $message .= "🔍 <b>Tips:</b>\n";
            $message .= "• Type /help to see guide\n";
            $message .= "• Use menu button for navigation\n";
            $message .= "• Make sure there are no typos in command\n\n";
            $message .= "🛠 Still confused? Contact @rinda_escobar";

            sendMessage($chatId, $message);
            break;
    }
}

/**
 * Perintah /start
 */
function cmdStart($chatId, $userId, $db)
{
    $message = "✨ <b>WELCOME</b> ✨\n\n";
    $message .= "Welcome to RINDA'S Bot\n";
    $message .= "Please use menu below for navigation.\n";
    
    sendMessage($chatId, $message, getMainKeyboard());
    
    // Log activity
    logBotActivity('command_start', $userId);
}