<?php
/**
 * Admin Panel - Dashboard
 */

// Include auth check
require_once 'auth_check.php';

// Get statistics
try {
    // Get total users
    $stmt = $db->query("SELECT COUNT(*) as total FROM users");
    $totalUsers = $stmt->fetch()['total'];
    
    // Get blocked users
    $stmt = $db->query("SELECT COUNT(*) as total FROM users WHERE is_blocked = 1");
    $blockedUsers = $stmt->fetch()['total'];
    
    // Get premium users
    $stmt = $db->query("
        SELECT COUNT(DISTINCT user_id) as total 
        FROM access_keys 
        WHERE is_used = 1 AND user_id IS NOT NULL
    ");
    $premiumUsers = $stmt->fetch()['total'];
    
    // Get total files
    $stmt = $db->query("SELECT COUNT(*) as total FROM files");
    $totalFiles = $stmt->fetch()['total'];
    
    // Get premium files
    $stmt = $db->query("SELECT COUNT(*) as total FROM files WHERE is_premium = 1");
    $premiumFiles = $stmt->fetch()['total'];
    
    // Get total downloads
    $stmt = $db->query("SELECT SUM(download_count) as total FROM files");
    $totalDownloads = $stmt->fetch()['total'] ?? 0;
    
    // Get used keys
    $stmt = $db->query("SELECT COUNT(*) as total FROM access_keys WHERE is_used = 1");
    $usedKeys = $stmt->fetch()['total'];
    
    // Get unused keys
    $stmt = $db->query("SELECT COUNT(*) as total FROM access_keys WHERE is_used = 0");
    $unusedKeys = $stmt->fetch()['total'];
    
    // Get recent activities
    $stmt = $db->query("
        SELECT bl.*, u.username, u.first_name, u.last_name 
        FROM bot_logs bl
        LEFT JOIN users u ON bl.telegram_id = u.telegram_id
        ORDER BY bl.created_at DESC
        LIMIT 10
    ");
    $recentActivities = $stmt->fetchAll();
    
    // Get recent users
    $stmt = $db->query("
        SELECT * FROM users 
        ORDER BY created_at DESC 
        LIMIT 5
    ");
    $recentUsers = $stmt->fetchAll();
    
    // Get recent files
    $stmt = $db->query("
        SELECT * FROM files 
        ORDER BY created_at DESC 
        LIMIT 5
    ");
    $recentFiles = $stmt->fetchAll();
} catch (PDOException $e) {
    $error = "Database error: " . $e->getMessage();
}

// Page title
$pageTitle = "Dashboard";
?>

<?php include 'include/header.php'; ?>

<!-- Dashboard content -->
<div class="container-fluid px-4">
    <h1 class="mt-4">Dashboard</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item active">Dashboard</li>
    </ol>
    
    <!-- Statistics cards -->
    <div class="row">
        <div class="col-xl-3 col-md-6">
            <div class="card bg-primary text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-0"><?php echo $totalUsers; ?></h4>
                            <div>Total Pengguna</div>
                        </div>
                        <div>
                            <i class="bi bi-people fs-1"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="members.php">Lihat Detail</a>
                    <div class="small text-white"><i class="bi bi-chevron-right"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-warning text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-0"><?php echo $premiumUsers; ?></h4>
                            <div>Member Premium</div>
                        </div>
                        <div>
                            <i class="bi bi-star fs-1"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="members.php?filter=premium">Lihat Detail</a>
                    <div class="small text-white"><i class="bi bi-chevron-right"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-success text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-0"><?php echo $totalFiles; ?></h4>
                            <div>Total File</div>
                        </div>
                        <div>
                            <i class="bi bi-file-earmark fs-1"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="files.php">Lihat Detail</a>
                    <div class="small text-white"><i class="bi bi-chevron-right"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-danger text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-0"><?php echo $totalDownloads; ?></h4>
                            <div>Total Download</div>
                        </div>
                        <div>
                            <i class="bi bi-download fs-1"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="files.php?sort=downloads">Lihat Detail</a>
                    <div class="small text-white"><i class="bi bi-chevron-right"></i></div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- More stats -->
    <div class="row">
        <div class="col-xl-6">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="bi bi-key me-1"></i>
                    Status Key Member
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card bg-light mb-3">
                                <div class="card-body">
                                    <h5 class="card-title">Key Terpakai</h5>
                                    <p class="card-text display-6 text-success"><?php echo $usedKeys; ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-light mb-3">
                                <div class="card-body">
                                    <h5 class="card-title">Key Tersedia</h5>
                                    <p class="card-text display-6 text-primary"><?php echo $unusedKeys; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-end mt-3">
                        <a href="keys.php" class="btn btn-primary btn-sm">Kelola Key</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="bi bi-file-earmark-text me-1"></i>
                    Status File
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card bg-light mb-3">
                                <div class="card-body">
                                    <h5 class="card-title">File Publik</h5>
                                    <p class="card-text display-6 text-info"><?php echo ($totalFiles - $premiumFiles); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-light mb-3">
                                <div class="card-body">
                                    <h5 class="card-title">File Premium</h5>
                                    <p class="card-text display-6 text-warning"><?php echo $premiumFiles; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-end mt-3">
                        <a href="files.php" class="btn btn-primary btn-sm">Kelola File</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent activities -->
    <div class="card mb-4">
        <div class="card-header">
            <i class="bi bi-activity me-1"></i>
            Aktivitas Terbaru
        </div>
        <div class="card-body">
            <table class="table table-striped table-sm">
                <thead>
                    <tr>
                        <th>Waktu</th>
                        <th>User</th>
                        <th>Aksi</th>
                        <th>Detail</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($recentActivities)): ?>
                        <tr>
                            <td colspan="4" class="text-center">Belum ada aktivitas</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($recentActivities as $activity): ?>
                            <tr>
                                <td><?php echo date('d/m/Y H:i', strtotime($activity['created_at'])); ?></td>
                                <td>
                                    <?php 
                                        if (!empty($activity['username'])) {
                                            echo '@' . htmlspecialchars($activity['username']);
                                        } elseif (!empty($activity['first_name'])) {
                                            echo htmlspecialchars($activity['first_name'] . ' ' . $activity['last_name']);
                                        } else {
                                            echo 'ID: ' . $activity['telegram_id'];
                                        }
                                    ?>
                                </td>
                                <td><?php echo htmlspecialchars($activity['action']); ?></td>
                                <td><?php echo htmlspecialchars($activity['details']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'include/footer.php'; ?>