<?php
/**
 * Admin Panel - Broadcast Messages
 */

// Include auth check
require_once 'auth_check.php';

// Process broadcast form
$successMessage = '';
$errorMessage = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['broadcast_message'])) {
    // Validate input
    $message = trim($_POST['broadcast_message']);
    $targetAudience = isset($_POST['target_audience']) ? $_POST['target_audience'] : 'all';
    
    if (empty($message)) {
        $errorMessage = "Pesan tidak boleh kosong.";
    } else {
        // Load bot functions
        require_once '../bot/functions.php';
        
        // Load .env variables
        require_once __DIR__ . '/../vendor/autoload.php';
        $dotenv = Dotenv\Dotenv::createImmutable(dirname(__DIR__));
        $dotenv->load();
        
        try {
            // Connect to database
            $db = connectDB();
            
            if (!$db) {
                throw new Exception("Gagal terhubung ke database");
            }
            
            // Send broadcast
            $onlyPremium = ($targetAudience === 'premium');
            $result = broadcastMessage($message, $db, $onlyPremium);
            
            if ($result !== false) {
                $audience = $onlyPremium ? 'member premium' : 'semua pengguna';
                $successMessage = "Pesan broadcast berhasil dikirim ke $audience. Terkirim: {$result['success']}, Gagal: {$result['failed']}, Total: {$result['total']}";
            } else {
                $errorMessage = "Terjadi kesalahan saat mengirim pesan broadcast.";
            }
        } catch (Exception $e) {
            $errorMessage = "Error: " . $e->getMessage();
        }
    }
}


// Page title
$pageTitle = "Broadcast Pesan";
?>

<?php include 'include/header.php'; ?>

<div class="container-fluid px-4">
    <h1 class="mt-4">Broadcast Pesan</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
        <li class="breadcrumb-item active">Broadcast Pesan</li>
    </ol>
    
    <?php if (!empty($successMessage)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo $successMessage; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($errorMessage)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo $errorMessage; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <div class="card mb-4">
        <div class="card-header">
            <i class="bi bi-megaphone me-1"></i>
            Kirim Pesan Broadcast
        </div>
        <div class="card-body">
            <form method="post" action="">
                <div class="mb-3">
                    <label for="target_audience" class="form-label">Target Audience</label>
                    <select class="form-select" id="target_audience" name="target_audience">
                        <option value="all">Semua Pengguna</option>
                        <option value="premium">Hanya Member Premium</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="broadcast_message" class="form-label">Pesan Broadcast</label>
                    <textarea class="form-control" id="broadcast_message" name="broadcast_message" rows="6" required placeholder="Tulis pesan broadcast di sini..."></textarea>
                    <div class="form-text">
                        Format HTML tersedia. Gunakan &lt;b&gt;teks&lt;/b&gt; untuk teks tebal, &lt;i&gt;teks&lt;/i&gt; untuk teks miring, dll.
                    </div>
                </div>
                <button type="submit" class="btn btn-primary">Kirim Broadcast</button>
            </form>
        </div>
    </div>
    
    <div class="card mb-4">
        <div class="card-header">
            <i class="bi bi-info-circle me-1"></i>
            Informasi Broadcast
        </div>
        <div class="card-body">
            <ul>
                <li>Pesan broadcast akan dikirim ke semua pengguna bot yang tidak diblokir.</li>
                <li>Jika memilih "Hanya Member Premium", pesan hanya akan dikirim ke pengguna yang memiliki akses premium.</li>
                <li>Gunakan fitur ini dengan bijak untuk menghindari spam.</li>
                <li>Perhatikan bahwa broadcast ke terlalu banyak pengguna mungkin memakan waktu.</li>
            </ul>
        </div>
    </div>
</div>

<?php include 'include/footer.php'; ?>